/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.graphics;

import org.eclipse.swt.*;

public class Transform extends Resource {

public Transform (Device device) {
	this(device, 1, 0, 0, 1, 0, 0);
}

public Transform (Device device, float[] elements) {
	this (device, checkTransform(elements)[0], elements[1], elements[2], elements[3], elements[4], elements[5]);
}

public Transform (Device device, float m11, float m12, float m21, float m22, float dx, float dy) {
	if (device == null) device = Device.getDevice();
	if (device == null) SWT.error(SWT.ERROR_NULL_ARGUMENT);
	this.device = device;
//	callNew(new Object[]{new Float(m11), new Float(m12), new Float(m21), new Float(m22), new Float(dx), new Float(dy)});
	if (device.tracking) device.new_Object(this);
}

static float[] checkTransform(float[] elements) {
	if (elements == null) SWT.error(SWT.ERROR_NULL_ARGUMENT);
	if (elements.length < 6) SWT.error(SWT.ERROR_INVALID_ARGUMENT);
	return elements;
}

void destroy () {
}

public void getElements (float[] elements) {
}

public void invert () {
}

public boolean isDisposed () {
	return device == null;
}

public boolean isIdentity () {
	return false;
}

public void multiply (Transform matrix) {
}

public void rotate (float angle) {
}

public void scale (float scaleX, float scaleY) {
}

public void setElements (float m11, float m12, float m21, float m22, float dx, float dy) {
}

public void transform (float[] pointArray) {
}

public void translate (float offsetX, float offsetY) {
}

public String toString () {
	if (isDisposed()) return "Transform {*DISPOSED*}";
	float[] elements = new float[6];
	getElements(elements);
	return "Transform {" + elements [0] + "," + elements [1] + "," +elements [2] + "," +elements [3] + "," +elements [4] + "," +elements [5] + "}";
}

}
